unit uWinProduKey;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Registry;

type
  TForm1 = class(TForm)
    bRegister: TButton;
    eProductKey: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    eDigitalID: TEdit;
    procedure bRegisterClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var
  HexBuf: array of byte;

function IsWow64: Boolean;
type
  TIsWow64Process = function( // Type of IsWow64Process API fn
    Handle: WinAPI.Windows.THandle; var Res: WinAPI.Windows.BOOL): WinAPI.Windows.BOOL; stdcall;
var
  IsWow64Result: WinAPI.Windows.BOOL; // Result from IsWow64Process
  IsWow64Process: TIsWow64Process; // IsWow64Process fn reference
begin
  Result := False;
  // Try to load required function from kernel32
  IsWow64Process := WinAPI.Windows.GetProcAddress(WinAPI.Windows.GetModuleHandle('kernel32'),
    'IsWow64Process');
  if Assigned(IsWow64Process) then
    if IsWow64Process(WinAPI.Windows.GetCurrentProcess, IsWow64Result) then
      Result := IsWow64Result;
end;


function DecodeProductKey(const HexSrc: array of Byte): string;
const
  StartOffset: Integer = $34;
  EndOffset: Integer = $34 + 15;
  Digits: array [0 .. 23] of Char = ('B','C','D','F','G','H',
   'J','K','M','P','Q','R','T','V','W','X','Y',
   '2','3','4','6','7','8','9');
  dLen: Integer = 29;
  sLen: Integer = 15;
var
  HexDigitalPID: array of Cardinal;
  Des: array of Char;
  i, n: Integer;
  hn, Value: Cardinal;
begin
  SetLength(HexDigitalPID, dLen);
  for i := StartOffset to EndOffset do
    HexDigitalPID[i - StartOffset] := HexSrc[i];
  SetLength(Des, dLen + 1);
  for i := dLen - 1 downto 0 do
  begin
    if (((i + 1) mod 6) = 0) then
      Des[i] :='-'
    else
    begin
      hn := 0;
      for n := sLen - 1 downto 0 do
      begin
        Value := (hn shl 8) or HexDigitalPID[n];
        HexDigitalPID[n] := Value div 24;
        hn := Value mod 24;
      end;
      Des[i] := Digits[hn];
    end;
  end;
  Des[dLen] := Chr(0);
  for i := 0 to Length(Des) do
    Result := Result + Des[i];
end;

function View_Win_Key: string;
var
  Reg: TRegistry;
  binarySize: integer;
  myAccess: Cardinal;
begin
  Result := '';
  myAccess := KEY_READ;
  if IsWow64 then
    myAccess := Key_Read or $0100;
  Reg := TRegistry.Create(myAccess);
  try
    Reg.RootKey := HKEY_LOCAL_MACHINE;
    if Reg.OpenKeyReadOnly('\SOFTWARE\Microsoft\Windows NT\CurrentVersion') then
    begin
      if Reg.GetDataType('DigitalProductId') = rdBinary then
      begin
        binarySize := Reg.GetDataSize('DigitalProductId');
        SetLength(HexBuf, binarySize);
        if binarySize > 0 then Reg.ReadBinaryData('DigitalProductId', HexBuf[0], binarySize);
        Result := DecodeProductKey(HexBuf);
      end;
    end;
  finally
    FreeAndNil(Reg);
  end;
end;

function DigitalID(const HexSrc: array of Byte): string;
const
  StartOffset: Integer = $34;
  EndOffset: Integer = $34 + 14;
var
  i: Integer;
begin
  Result := '';
  for i := StartOffset to EndOffset do
    Result := Result + IntToHex(HexSrc[i], 2) + ' ';
  Result := Trim(Result);
end;


procedure TForm1.bRegisterClick(Sender: TObject);
begin
  eProductKey.Text := View_Win_Key;
  eDigitalID.Text := DigitalID(HexBuf);
end;

end.
